# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)50   1.43   src/csm/install/pkgdefs/Linux-SLES8.1-ppc64.pm.perl, setup, csm_rameh, rameh0431a 7/6/04 06:35:53

#--------------------------------------------------------------------------------

=head3	 Linux-SLES8.1-ppc64.pm.perl

        Package Definition File:    SLES 8.1 ppc64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package  SLES81;

do "/opt/csm/install/pkgdefs/Linux.pm";

NodeUtils->messageFromCat(
                          'csmInstall.cat',
                          $::MSGMAPPATH,
                          'csminstall',
                          'V',
                          'IMsgLoading',
                          "/opt/csm/install/pkgdefs/Linux-SLES8.1-ppc64.pm"
                          );

my $_server_ = 'MgmtServer';
my $_node_   = 'MgdNode';

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    $::pkgdefs{DISTRO_NAME}     = "SuSE SLES 8.1 PPC";
    $::pkgdefs{DISTRO_DISKLIST} = "1 2 4";               # TO BE REMOVED
    $::pkgdefs{DISTRO_RPMDIR}   = "suse";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
    my $dd_ref = [
        {
         num  => '1',
         name => $::pkgdefs{DISTRO_NAME},

         #diskid_filename     => 'media.1/products',
         #diskid_searchstring => '/ SuSE-Linux-SLES-PPC 8',
         diskid_searchargs => {
                               file => 'media.1/products',
                               key  => '/ SuSE-Linux-SLES-PPC 8',
         },
         diskid_searchprog => \&Linux::linux_diskid_match_prog,
         diskid_target     => "sles8-ppc64",
        },
        {
         num  => '2',
         name => $::pkgdefs{DISTRO_NAME},

         #diskid_filename      => 'media.2/products',
         #diskid_searchstring  => '/ SuSE-Linux-SLES-PPC 8',
         not_for_full_install => 'TRUE',
         diskid_searchargs    => {
                               file => 'media.2/products',
                               key  => '/ SuSE-Linux-SLES-PPC 8',
         },
         diskid_searchprog => \&Linux::linux_diskid_match_prog,
         diskid_target     => "sles8-ppc64",
        },
        {
         num  => '1',
         name => $::pkgdfs{DISTRO_NAME} . ' Supplementary',

         #diskid_filename      => 'media.1/products',
         #diskid_searchstring  => '/ SuSE-Linux-SLES-PPC-SUPP 1',
         not_for_full_install => 'TRUE',
         diskid_searchargs    => {
                               file => 'media.1/products',
                               key  => '/ SuSE-Linux-SLES-PPC-SUPP 1',
         },
         diskid_searchprog => \&Linux::linux_diskid_match_prog,
         diskid_target     => "sles8-ppc64",
        },
        ];

    $::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $sp3_ref = [
        {
         num  => '1',
         name => "SuSE SLES 8.1 SP3 PPC",

         #	    diskid_filename     => '',
         #	    diskid_searchstring => '',
         diskid_searchargs => {
                               file => 'media.1/products',
                               key  => '/ SuSE-Linux-SLES-PPC 3',
         },
         diskid_searchprog => \&Linux::linux_diskid_match_prog,
         diskid_target     => "sles8-sp3",
        },
        ];

    $::pkgdefs{sp_disks}{SP3} = $sp3_ref;
}

#--------------------------------------------------------------------------------

{
    my $sp3a_ref = [
        {
         num  => '1',
         name => "SuSE SLES 8.1 SP3A PPC",

         #	    diskid_filename     => '',
         #	    diskid_searchstring => '',
         diskid_searchargs => {
                               file => 'media.1/products',
                               key  => '/ SuSE-Linux-SLES-PPC 3a',
         },
         diskid_searchprog => \&Linux::linux_diskid_match_prog,
         diskid_target     => "sles8-sp3a",
        },
        ];

    $::pkgdefs{sp_disks}{SP3A} = $sp3a_ref;
}

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $opr_ref;

    # defaults
    $opr_ref{$_server_}{$::csm_version} =
      ['tftp-hpa', 'IBMJava2-JRE-ppc-1.4.1', 'conserver', 'openCIMOM-0.8-1'];
    $opr_ref{$_node_}{$::csm_version} = ['autoupdate'];

    # exceptions  - must follow the default assignments.
    $opr_ref{$_node_}{'1.2.0'} = [];

    # server and node exception
    if ($::ITDAGENT eq "true")
    {
        $opr_ref{$_server_}{$::csm_version} =
          [@{$opr_ref{$_server_}{$::csm_version}}, 'ITDAgent'];
        $opr_ref{$_node_}{$::csm_version} =
          [@{$opr_ref{$_node_}{$::csm_version}}, 'ITDAgent'];
    }

    $::pkgdefs{opensrc_prereqs} = $opr_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rp_ref;

    # defaults
    $rp_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];
    $rp_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];

    # exceptions  - must follow the default assignments.
    # none
    $rp_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];

    $::pkgdefs{rsct_packages} = $rp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cp_ref;

    # defaults
    $cp_ref{$_server_}{$::csm_version} =
      ['csm.core', 'csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];
    $cp_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.client', 'csm.diagnostics'];

    # exceptions  - must follow the default assignments.
    $cp_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	director_packages - Director Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $dp_ref;

    # defaults
    $dp_ref{$_server_}{$::csm_version} = ['csm.director.agent'];
    $dp_ref{$_node_}{$::csm_version}   = ['csm.director.agent'];

    # exceptions  - must follow the default assignments.
    $dp_ref{$_node_}{'1.2.0'}   = [];
    $dp_ref{$_node_}{'1.3.0'}   = [];
    $dp_ref{$_node_}{'1.3.1'}   = [];
    $dp_ref{$_node_}{'1.3.2'}   = [];

    $::pkgdefs{director_packages} = $dp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_unpackages - RSCT Packages to uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rup_ref;

    # defaults
    $rup_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];
    $rup_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];

    # exceptions  - must follow the default assignments.
    # none
    $rup_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];

    $::pkgdefs{rsct_unpackages} = $rup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_unpackages - CSM Packages to uninstall	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cup_ref;

    # defaults
    $cup_ref{$_server_}{$::csm_version} =
      ['csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];
    $cup_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.diagnostics', 'csm.client'];

    # exceptions  - must follow the default assignments.
    $cup_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_unpackages} = $cup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cud_ref;

    # defaults
    $cud_ref{$_server_}{$::csm_version} = ['/csminstall', '/cfmroot'];
    $cud_ref{$_node_}{$::csm_version}   = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cnip_ref;

    # defaults
    $cnip_ref{$_server_}{$::csm_version} = ['csm.core'];
    $cnip_ref{$_node_}{$::csm_version}   = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_nouninstall_pkgs} = $cnip_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_csm

	CSM binaries to be copied

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
    my $cbcc_ref;

    # DEFAULT
    $cbcc_ref{$::csm_version} = [
                                 '/opt/csm/csmbin/updatenode.client',
                                 '/opt/csm/csmbin/write_status',
                                 '/opt/csm/msgmaps/csmInstall.csminstall.map',
                                 '/opt/csm/pm/MessageUtils.pm',
                                 '/opt/csm/pm/NodeUtils.pm',
                                 '/opt/csm/pm/ArchiveUtils.pm',
                                 '/opt/csm/pm/InstallUtils.pm',
                                 '/opt/csm/pm/InstallKRB5Utils.pm',
                                 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
                                 '/opt/csm/pm/NetworkUtils.pm',
                                 '/opt/csm/pm/ServerUtils.pm',
                                 '/opt/csm/pm/CSMDefs.pm',
                                 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                                 '/opt/csm/csmbin/rmnode_client',
                                 '/opt/csm/bin/setupconsole',
                                 '/opt/csm/csmbin/makenode',
                                 '/opt/csm/csmbin/setbootdisk',
                                 '/opt/csm/csmbin/csmprereboot',
                                 '/opt/csm/csmbin/csmfirstboot',
                                 '/opt/csm/install/defs',
                                 '/opt/csm/install/pkgdefs',
                                 '/opt/csm/csmbin/nodestatus.client'
                                 ];

    # exceptions
    $cbcc_ref{'1.2.0'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/usr/bin/tftp',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs'
                          ];
    $cbcc_ref{'1.3.0'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/usr/bin/tftp',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs'
                          ];
    $cbcc_ref{'1.3.1'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/setbootdisk',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/usr/bin/tftp',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs'
                          ];
    $cbcc_ref{'1.3.2'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/setbootdisk',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs',
                          '/opt/csm/csmbin/nodestatus.client'
                          ];

    $::pkgdefs{csm_bin_copy_csm} = $cbcc_ref{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_tftpboot	

	 CSM binaries copied to /tftpboot directory

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
    my $cbct_ref;

    # defaults
    $cbct_ref{$::csm_version} = [];

    # exceptions
    # none

    $::pkgdefs{csm_bin_copy_tftpboot} = $cbct_ref{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $ospr_ref;

    $ospr_ref{$_server_} = [
                            'perl-5*',      'nfs-utils-*',
                            'pdksh-*',      'dhcp-base*',
                            'dhcp-server*', 'rdist-6*',
                            'tcl-8*',       'tk-8*',
                            'expect-5*',    'xf86-*',
                            'freetype2-*',  'rsync-*',
                            'rsh-server-*', 'termcap-*',
                            'perl-XML-RegExp-*'
                            ];
    $ospr_ref{$_node_} = [
                          'perl-5*',      'nfs-utils-*',
                          'pdksh-*',      'dhcp-base*',
                          'dhcp-server*', 'rdist-6*',
                          'tcl-8*',       'tk-8*',
                          'expect-5*',    'xf86-*',
                          'freetype2-*',  'rsync-*',
                          'rsh-server-*'
                          ];

    $::pkgdefs{os_prereqs} = $ospr_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------

=head3	logfiles	

	CSM Log files ( used while uninstalling)

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
    my $lf_ref;

    $lf_ref{$_server_} = [
                          '/var/log/csm/csmsetupsis.log*',
                          '/var/log/csm/installnode.log*',
                          '/var/log/csm/updatenode.log*',
                          '/var/log/csm/installms.log*'
                          ];
    $lf_ref{$_node_} = ['/var/log/csm/install.log*', '/var/opt/csm/cfmlocal*'];

    $::pkgdefs{logfiles} = $lf_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------

=head3	Misc. global variables

	should be moved elsewhere...	

	definately move somewhere else!  - maybe the registry

        Notes:

=cut

#--------------------------------------------------------------------------------
{

    %::rpm_pkg_flag = ();
    $::rpm_pkg_flag{openCIMOM} = " --ignoreos";

    #default kernel path name based on SUSE_TOP
    $::kernel_path_name =
      "sles8-ppc64/suse/ppc/kernel-ppc64-2.4.19-108.ppc.rpm";

}

#--------------------------------------------------------------------------------

1;    # end
